﻿# -*- coding: utf-8 -*-
"""
Created on Tue Oct  5 18:19:30 2021

@author: Adrian Ringenbach
#slightly updated by Marlene Kronenberg July 2022

"""
##example script to call the ADG using the necessary inputs and writing the deadwood .pts files in a output folder 

#import modlue
import sys
import time

sys.path.append(r'D:\...\ADG') 				#adapt path to the downloaded ADG package
from DeadWoodModule20220727 import *

#Import input data
input_dem=r'D:\...\ADG\input\DEM.tif'    		# TIFF format
treefile=r'D:\...\ADG\input\forest_trees_test.txt'	# treefile conatining either the ramms tree file, or a list with at leat 4 colums: 
							# x-coordinate, y-coordinate, tree height, tree diameter
out_folder=r'D:\...\ADG\output'				# output folder 

#ADG-Parameters 
state='old' 			# DW-state ('old'/'fresh'): deadwood vs 10-year-old, decayed deadwood.
mainWindDir=135 		# Main wind direction in degrees (Number input between 0 and 360): North =0°, east = 90°, south= 180°, west = 270°.
sigmaWinDir=45			# Standard deviation of wind direction (Number input between 0 and 360)
rp_percentage=0.33 		# Percentage of overturned trees with rootplates  
upscaleFact=10 			# Upscale factor of the DEM resolution: (DEM input resolution)/Upscale factor = roughly 20 cm. Meaning: With an DEM input resolution = 2m the upscale factor was set to 10, resulting in 20 cm resolution of the DSM within the DWG. 20 cm are realistic to get a proper piling up effect
WindThorwPercentage=0.5 	# Percentage of the standing trees within the input tree files which will be affected. 
DBH_thrs=0.08			# Threshold of the standing tree DBH below which the deadwood is neglected. If threshold is too low, the piling up effect may be overestimated, as also Deadwood log of 60 cm diameter will stop on top of a small deadwood log with 5 cm diameter

t = time.time() 		#start stopwatch
dem_res, winDir, rp_state, wt_state=DWG(input_dem, treefile, out_folder, state, mainWindDir, sigmaWinDir, rp_percentage, upscaleFact, WindThorwPercentage,DBH_thrs)
elapsed = time.time() - t	#stop stopwatch
print ("elapsed time: " + str(round(elapsed/60,2))+" min for processing Treefile with "+str(len(rp_state))+"trees, assuming a windthrow ratio of: "+ str(100*WindThorwPercentage)+ "% and a root plate ratio of: "+ str(100*rp_percentage) +"%.")

print('end')