# Configuration file for the one-dimensional model

# assume constant air density (kg m-3) like in LES
rho_sub = 1.18

# Use saltation levels?
use_salt_levels = T # T means that we account for sublimation in the saltation layer.
                    # F means that we neglect sublimation in the saltation layer and only compute sublimation at the fine and coarse levels
# Impose friction velocity?
impose.ustar = T # T means that friction velocity is imposed as in LES
                 # F means that friction velocity is computed from wind speed at first coarse level via Monin-Obukhov formula (same wind speed as in steady state in LES)
# shape parameter of gamma distribution
parametrize.alpha = T # T means that alpha is a constant value specified below
                      # F means that alpha varies with height and is computed from LES profiles of blowing snow mass and number mixing ratios and mean particle diameter
alpha.const = 3 # 3 is default in CRYOWRF; only used if parametrize.alpha = T
parametrize.d = T # T means that mean particle diameter in saltation layer is a linear profile defined by dp.hsalt and dp.salt.first (see below)
                  # F means that mean particle diameter is taken from LES output
                  # This parameter does not influence the mean particle diameter above the saltation layer (which depends on parametrize.qi).
# assumed mean particle diameter (m) at top of saltation layer if parametrize.d == T
dp.hsalt       = 0.000200 # default in CRYOWRF
# assumed mean particle diameter (m) at lowest saltation level if parametrize.d == T
dp.salt.first  = 0.000200
parametrize.qi= "all" # options are "no"         (drifting/blowing snow mass mixing ratios are taken from LES results), 
                      #             "suspension" (only parametrize drifting/blowing snow mass mixing ratios at suspension levels while taking values from LES at levels up to saltation layer height),
                      #             "all"        (parametrize drifting/blowing snow mass mixing ratio at all levels)
parametrize.h_salt = "pomeroy_male" # options are "pomeroy_male", "lehning", or a numeric value in meter (see next line)
# parametrize.h_salt = 0.0375 #0.1875 #0.2025 #0.1275 #0.2925
# Compute friction velocity profile as function of height and surface/threshold friction velocity according to Raupach (1991)? This option affects the eddy diffusivity close to the surface.
ustar.Raupach = "LES-based" # options: "LES-based": insert surface friction velocity from LES in Raupach formula (instead of threshold friction velocity like in large-scale models)
                            #          "no":        use height-constant friction velocity
# Parameters for prognostic blowing snow mixing ratios or threshold friction velocity
if( parametrize.qi != "no" ){
  # Type of finite difference used for sedimentation term in prognostic equation for blowing snow mixing ratios; options are "forward" (currently used in CRYOWRF), "central", and "q_forward_v_backward"
  # sedimentation_option = "forward"
  sedimentation_option = "q_forward_v_backward"
  # sedimentation_option = "central"
}
if(parametrize.qi == "all"){
  parametrize.int.salt.conc = T # T means that integrated saltation mass concentration (kg m-2) is parametrized as in CRYOWRF
                                # F means that this value is derived from the LES-LSM data
}
# Only one level in saltation layer?
only1salt.level = F # T means only one level (z=0.0075 m) in saltation layer
                    # F means one level every 0.015 m in saltation layer.
# How to compute T and q in fine mesh (and saltation mesh)?
# T.q.option = "linear_without_salt_layer"
# T.q.option = "linear"
# T.q.option = "MO-bulk"
T.q.option = "prognostic"
if(T.q.option != "prognostic"){
  feedback.on.surfFlux = F # This setting does not affect the steady-state results!
                           # T means flux contribution of saltation and fine meshes is added to the surface flux;
                           # F means this contribution changes directly the temperature and specific humidity at the first coarse level
}
# Base sublimation in saltation layer on modified or original Thorpe-Mason formula?
modify.TM.below30cm = T # T means accounting for transient particle temperature
                        # F means assuming stationary particle temperature (original Thorpe-Mason formula).
# height of first coarse full levels (m), corresponding to WRF W-level
z_firstlev = 4.5
# height of upper boundary (for temperature and humidity)
z_top_boundary = 9
# heights (m) of fine mesh (half nodes between h_salt and 0.5*z_firstlev)
log_spacing_fine = T
if(log_spacing_fine){
  Z_fine = c(0.15, 0.23, 0.35, 0.54, 0.83, 1.27, 1.96)  # moderate vertical resolution: log spacing which could be used in CRYOWRF while keeping a number of 8 fine levels (from 0.15 m to 3 m)
  # Z_fine = "high_res"                                 # high vertical resolution: first fine level is 0.015 m above h_salt 
}else{
  Z_fine = c(0.5, 0.86, 1.21, 1.57, 1.92)               # low vertical resolution: linear spacing similar to current near-surface spacing in CRYOWRF
}
# spacing (m) between saltation levels
dz_salt = 0.015
# time step (s) for parametrized simulation
dt_in = 0.002 # 0.0015
# total number of time steps in parametrized simulation
nstep_max = ceiling(100/dt_in)
# output interval (s)
interval.out = 1
# factor for shifting T and q upper boundary conditions closer to surface values (for sensitivity tests)
# f.shift.BC.top = 0.1 # shift by 10% towards lower boundary condition
f.shift.BC.top = 0     # no shift
# compute surface fluxes using stability correction?
corr.stability = T
# use default roughness length from CRYOWRF (0.002 m)?
default.z0 = F # T means that the aerodynamic, thermal, and humidity roughness lengths are set to 0.002 m
               # F means that the roughness lengths are set to the same values as in the LES (see below)
               # This parameter may influence the friction velocity and height of the saltation layer

if(case == "case1_dx10cm"){
  
  # relative paths and file names of input files
  file.forcings.LES.mesh = "../LES-LM_main_results/processed_profiles_case1_dx10cm_350-750s.Rdata"
  file.measured          = "../Postprocessing_code/config_measured_values_S17_190111_0045.R"
  # roughness length for momentum (m)
  rough_len_m_LES = 1e-4
  # roughness length for scalars (temperature and humidity) (m)
  rough_len_t_LES = 5e-5
  rough_len_q_LES = 5e-5
  # surface temperature (K)
  TSK    = 267.52
  # surface specific humidity (kg kg-1)
  QSFC   = 0.00261312855682389
  # upper boundary conditions  at height of 9 m for parametrized simulation
  # Dirichlet type: derived from LES
  BC_T_top = list(-4.093 + 273.15, "DRC") # K
  BC_q_top = list(2.502 / 1000, "DRC") # kg kg-1
  # initial T and q, taken from LES
  temp_coarse_init = c(-4.3416, -4.0653) + 273.15  # K
  qv_coarse_init   = c(2.537, 2.509) / 1000    # kg kg-1
  if(impose.ustar){
    # friction velocity (m s-1) imposed in LES and 1D model
    ustar.fix = 0.605
  } else{
    # wind speed (m s-1) at z = 0.5*z_firstlev in LES in drifting snow conditions because in CRYOWRF we aim to reproduce measured wind speeds (for realistic advection term etc.) although a slowdown of the wind due to drifting/blowing snow is not implemented
    vw_coarse_first = 12.5 #14.1 #13.4 #15.3
  }
  # mean particle diameter (m) of surface snow in LES
  # dp.surf = 0.00019
  
} else{ if(case == "case2_dx10cm"){
  
  # relative paths and file names of input files
  file.forcings.LES.mesh = "../LES-LM_main_results/processed_profiles_case2_dx10cm_350-750s.Rdata"
  file.measured          = "../Postprocessing_code/config_measured_values_S17_190112_1105.R"
  # roughness length for momentum (m)
  rough_len_m_LES = 1e-4
  # roughness length for scalars (temperature and humidity) (m)
  rough_len_t_LES = 5e-5
  rough_len_q_LES = 6e-5
  # surface temperature (K)
  TSK    = 270.38
  # surface specific humidity (kg kg-1)
  QSFC  = 0.003296502626
  # upper boundary conditions for parametrized simulation
  # Dirichlet type: taken from LES at 9m height
  BC_T_top = list(-3.630 + 273.15, "DRC") # K
  BC_q_top = list(3.028 / 1000, "DRC") # kg kg-1
  # initial T and q, taken from LES
  temp_coarse_init = c(-3.533, -3.610) + 273.15  # K
  qv_coarse_init   = c(3.062, 3.035) / 1000    # kg kg-1
  if(impose.ustar){
    # friction velocity (m s-1) imposed in LES and 1D model
    ustar.fix = 0.600
  } else{
    # wind speed (m s-1) at z = 0.5*z_firstlev = 2.25 m in LES in drifting snow conditions because in CRYOWRF we aim to reproduce measured wind speeds (for realistic advection term etc.)
    vw_coarse_first = 12.2 #13.4
  }
  # mean particle diameter (m) of surface snow in LES
  # dp.surf = 0.00016
  
} else{ if(case == "case3a_dx10cm"){
  
  # relative paths and file names of input files
  file.forcings.LES.mesh = "../LES-LM_main_results/processed_profiles_case3a_dx10cm_350-750s.Rdata"
  file.measured          = "../Postprocessing_code/config_measured_values_S17_190111_2145.R"
  # roughness length for momentum (m)
  rough_len_m_LES = 1e-4
  # roughness length for scalars (temperature and humidity) (m)
  rough_len_t_LES = 3e-5
  rough_len_q_LES = 4e-5
  # surface temperature (K)
  TSK    = 268.71
  # surface specific humidity (kg kg-1)
  QSFC  = 0.002880118
  # upper boundary conditions for parametrized simulation
  # Dirichlet type: taken from LES at 9m height
  BC_T_top = list(-4.658 + 273.15, "DRC") # K
  BC_q_top = list(2.824 / 1000, "DRC") # kg kg-1
  # initial T and q, taken from LES
  temp_coarse_init = c(-4.631, -4.652) + 273.15  # K
  qv_coarse_init   = c(2.831, 2.825) / 1000    # kg kg-1
  if(impose.ustar){
    # friction velocity (m s-1) imposed in LES and 1D model
    ustar.fix = 0.787
  } else{
    # wind speed (m s-1) at z = 0.5*z_firstlev = 2.25 m in LES in drifting snow conditions because in CRYOWRF we aim to reproduce measured wind speeds (for realistic advection term etc.)
    vw_coarse_first = 15.7 #18.4
  }
  # mean particle diameter (m) of surface snow in LES
  # dp.surf = 0.00015

} else{ if(case == "case3b_dx10cm"){
  
  # relative paths and file names of input files
  file.forcings.LES.mesh = "../LES-LM_main_results/processed_profiles_case3b_dx10cm_350-750s.Rdata"
  file.measured          = "../../LES_output_postprocessing/config_measured_values_S17_190111_2145.R"
  # roughness length for momentum (m)
  rough_len_m_LES = 1e-4
  # roughness length for scalars (temperature and humidity) (m)
  rough_len_t_LES = 3e-5
  rough_len_q_LES = 4e-5
  # surface temperature (K)
  TSK    = 268.71
  # surface specific humidity (kg kg-1)
  QSFC  = 0.002880118
  # upper boundary conditions for parametrized simulation
  # Dirichlet type: taken from LES at 9m height
  BC_T_top = list(-3.730 + 273.15, "DRC") # K
  BC_q_top = list(3.040 / 1000, "DRC") # kg kg-1
  # initial T and q, taken from LES
  temp_coarse_init = c(-3.822, -3.749) + 273.15  # K
  qv_coarse_init   = c(3.020, 3.036) / 1000    # kg kg-1
  if(impose.ustar){
    # friction velocity (m s-1) imposed in LES and 1D model
    ustar.fix = 0.787
  } else{
    # wind speed (m s-1) at z = 0.5*z_firstlev = 2.25 m in LES in drifting snow conditions because in CRYOWRF we aim to reproduce measured wind speeds (for realistic advection term etc.)
    vw_coarse_first = 15.6 #18.5
  }
  # mean particle diameter (m) of surface snow in LES
  # dp.surf = 0.00015
  
} else{
 
  warning(paste("case =",case,"is not implemented in config.parametrize.R"))
   
}}}}

# roughness lengths (m) actually used in the 1D model
if(default.z0){
  rough_len_m = rough_len_t = rough_len_q = 0.002
} else{
  rough_len_m = rough_len_m_LES
  rough_len_t = rough_len_t_LES
  rough_len_q = rough_len_q_LES
}
