# Function for saturation vapour pressure (Pa) with respect to ice as in the LES
# t : temperature in degree Celsius

calc_es_les = function(t){
  611.15 * exp( (23.036 - t/333.7) * (t/(279.82 + t)))
}


# Function for calculating relative humidity with respect to ice from temperature, specific humidity and air density

## Input:
# Temp   temperature (K)
# q      specific humidity (kg kg-1)
# rho    air density (kg m-3)

## Output:
# relative humidity (%)

calc_RH_ice = function(Temp,q,rho){
  R_universal = 8.314 # J mol-1 K-1
  # saturation vapour pressure (Pa)
  e.sat = calc_es_les(t = Temp - 273.15)
  # saturation vapor density as calculated in LES [kg/m^3]
  v.dens.sat = (0.018015 * e.sat)/(R_universal * Temp)
  # saturation specific humidity as calculated in LES [kg/kg]
  q.sat = v.dens.sat / rho
  # RH (%)
  q / q.sat * 100
}