# Function for calculating drifting snow mass mixing ratio [kg kg-1] or its horizontal flux (kg kg-1 m s-1) at a given height from total mass concentration in saltation
# adapted from Nishimura and Hunt (2000). 

# conc          concentration [kg m-2] or transport rate (kg m-1 s-1)
# ustar         friction velocity (m s-1) above the snow transport layer, usually positive, otherwise zero is returned
# z_decay_max   maximum decay height (m), e.g., 0.04 m as LES-LSM simulations of Melo et al. (2024) suggest that it becomes nearly invariant with friction velocity for high friction velocities.

calc_q_bs_in_saltation = function(z, conc, ustar, rho_air, lambda_csalt = 0.45, z_decay_max = NA){
  # term in formula for drifting snow mixing ratio as function of height
  z_decay = if(ustar > 0.0){
    min( c(ustar^2 / (lambda_csalt * 9.81), z_decay_max), na.rm = T )
  } else{
    0
  }
  # 
  c_salt = conc / z_decay * exp( -1.0 * z / z_decay ) # [kg m-3] or (kg m-2 s-1)
  c_salt / rho_air # [kg kg-1] or (kg kg-1 m s-1)
}
