# Function for computing friction velocity at given height in drifting snow conditions according to Raupach (1991)

calc_ustar_raupach = function(z, ustar, ustar.t, h.salt){
  # ratio
  if(ustar > ustar.t){
    my_ratio = ustar.t/ustar
  } else{
    my_ratio = 1
  }
  ( 1 - (1 - my_ratio) * exp(-z/h.salt) ) * ustar 
}