# Function for calculating a zero (only real part) of a third order polynomial in a given range of values

## Input:
# z     coefficients as in "polyroot"
# lim   lower and upper plausibility limit for the zero (solution). Numeric of length 2. 

## Output
# Real number (Numeric).

solve_poly3 = function(z, lim){
  if(any(is.na(z))) return(NA)
  # find zeros of third order polynomial
  a = polyroot(z = z)
  # select the real number, which is in a plausible range (imaginary part must be approximately zero)
  ind = which( abs(Im(a)) < 1e-10 & Re(a) >= lim[1] & Re(a) < lim[2])
  if(length(ind) > 1){
    stop(paste("More than one real solution of third order polynomial in specified range (for z[1] =", z[1],")."))
  } else{
    if(length(ind) == 0){
      warning("No real solution of third order polynomial in specified range (for z[1] =", z[1],"). Returning NA.")
      return( NA )
    } else{
      return( Re( a[ind] ) )
    }
  }
}