# Script for bin-averaging temporal change of particle temperature (LES-LM results) for later use in linear regression
# Averaging over time, height and particle diameter

# Armin Sigmund


# Settings ----------------------------------------------------------------

rm(list= ls())

# working directory
setwd("~/Documents/PhD_work/my_paper_drafts/paper_parametrization/data_for_EnviDat/Postprocessing_code/")

source(file = "my_functions/func_extract_profile_from_particles.R")

my.cases = c("1","2","3a","3b")

path.LES = "../LES-LM_main_results/"
fn = c(file.path(path.LES, "processed_profiles_case1_dx10cm_350-750s.Rdata"),
       file.path(path.LES, "processed_profiles_case2_dx10cm_350-750s.Rdata"),
       file.path(path.LES, "processed_profiles_case3a_dx10cm_350-750s.Rdata"),
       file.path(path.LES, "processed_profiles_case3b_dx10cm_350-750s.Rdata"))

fn.ptcl = c("../LES-LM_particles_case_1.Rdata",
            "../LES-LM_particles_case_2.Rdata",
            "../LES-LM_particles_case_3a.Rdata",
            "../LES-LM_particles_case_3b.Rdata")

# particle density (kg m-3)
P_RHO = 918.4
# domain length and width (m)
L_X = 19.2
L_Y = 18.32
# air density (kg m-3)
rho_air = 1.18
# Normalization factor for temperature for Case 1, 2, 3a, and 3b, respectively
t_scale = c(267.52, 270.38, 268.71, 268.71)


# Read and process data ---------------------------------------------------

for(case in my.cases){
  
  # index of the case
  in.case = match(x = case, table = my.cases)
  # load grid heights
  load(fn[in.case])
  # number of grid levels (adjacent to the surface) to be used (corresponding to lowest 0.3 m)
  nlay = 20
  # height (m)
  my.z = run1$ta1$z[1:nlay]

  # Load particles data
  load(fn.ptcl[in.case])
  
  # upper boundary of grid layers to consider
  bound = run1$z.w[c(2:(nlay+1),length(run1$z.w))]
  # label of grid layer for each parcel
  ptcl$layer = findInterval(ptcl$z_p, bound) #sapply(ptcl$z_p, function(x){sum(!(x <= bound))})
  # discard uppermost layer (above approx. 0.3 m)
  ptcl = ptcl[which(ptcl$layer < nlay),]
  
  # use two subperiods of 200 s each
  t.sub    = max(ptcl$time) - c(400, 200)
  in.sub.1 = which( ptcl$time > t.sub[1] & ptcl$time <= t.sub[2] )
  in.sub.2 = which( ptcl$time > t.sub[2] )
  part     = list(tp1 = ptcl[in.sub.1, ], tp2 = ptcl[in.sub.2, ])
  rm(ptcl)
  gc()
  d_p_center = avg.per.dp = ntot.per.dp = N.p = list(tp1 = NA, tp2 = NA)
  
  for (k in 1:length(part)) {
    # time in s
    time.part = sort(unique(part[[k]]$time))
    # indexes of layers covered by data
    ind.col   = 1 + sort(unique(part[[k]]$layer))
    #range(part[[k]]$d_p)
    # size bin (10 micron intervals)
    delta_d_p = 10e-6
    part[[k]]$bin_d_p = floor(part[[k]]$d_p / delta_d_p)
    # range.bin = range(part[[k]]$bin_d_p)
    # bin numbers covered by data
    bin.number = sort(unique(part[[k]]$bin_d_p))
    # center of size bins (microns) covered by data
    d_p_center[[k]] = delta_d_p*bin.number + 0.5*delta_d_p
    # number of particles per parcel
    part[[k]]$ppp = part[[k]]$mass_p / (P_RHO*pi*part[[k]]$d_p^3 / 6)
    
    # total number of particles per layer and diameter class (instead of time, diameter bins are used here)
    ntot.per.dp[[k]] = extract_profile_from_particles(data = part[[k]]$ppp, INDEX = list(d_p = part[[k]]$bin_d_p, layer = part[[k]]$layer),
                                                      ncol = length(ind.col), ind.column = ind.col, default = 0, with.time = T)[[2]]
    # average particle number mixing ratio (kg-1) per layer and diameter class
    N.p[[k]] = t(apply(ntot.per.dp[[k]], 1, function(i){
      i / length(time.part) / (L_X*L_Y*diff( c(0,bound[1:length(ind.col)]) ) * rho_air)
    }))
    
    # average particle quantities per layer and diameter class 
    vars.proc = "delta_T" #c("delta_T","T_p","delta_m")
    in.proc = match(vars.proc, names(part[[k]]))
    avg.per.dp[[k]] = lapply(in.proc, function(i){
      extract_profile_from_particles(data = part[[k]]$ppp * part[[k]][,i], INDEX = list(d_p = part[[k]]$bin_d_p, layer = part[[k]]$layer),
                                     ind.column = ind.col, normaliz.matrix = ntot.per.dp[[k]], default = NA, 
                                     ncol = length(ind.col), with.time = T)[[2]]
    })
    names(avg.per.dp[[k]]) = vars.proc
    for(i in 1:length(avg.per.dp[[k]])){
      rownames(avg.per.dp[[k]][[i]]) = d_p_center[[k]]
      colnames(avg.per.dp[[k]][[i]]) = round(my.z, digits = 4)
    }
  }
  
  # save processed data
  save(avg.per.dp, d_p_center, file = paste("particles_per_d_and_z_Case_", case, ".Rdata", sep = ""))
  
}
