# Script for plotting particle size distributions using data prepared with 5_prepare_size_distribution_SPC_LES.R

# Settings ----------------------------------------------------------------------------------------
rm(list=ls())
setwd("~/Documents/PhD_work/my_paper_drafts/paper_parametrization/data_for_EnviDat/Postprocessing_code/")

path.Rdata = list.files(pattern = "PSD_data", full.names = T)

cases = c("1","2","3a")
# diameters for evaluating the fitted gamma distribution (micrometer) 
x1 = seq(30,500)
x2 = seq(0,730)

# borders of 64 particle diameter classes of SPC (micrometer) 
br = c(30,seq(43,253,7),seq(261,324,7),seq(332,381,7),seq(389,431,7),seq(439,474,7),482,NA)


# load and prepare data for plot ------------------------------------------------------------------
spc.density  = list()
spc.dens.fit = list()
les.density  = list()
les.dens.fit = list()
for(i in 1:length(path.Rdata)){
  load(file = path.Rdata[i])
  spc.density[[i]] = spc_dens_particles
  les.density[[i]] = les_dens_particles
  spc.dens.fit[[i]] = lapply(fit.distr, function(i){dgamma(x = x1, shape = i$estimate[1], rate = i$estimate[2])})
  les.dens.fit[[i]] = lapply(fit.les.distr, function(i){dgamma(x = x2, shape = i$estimate[1], rate = i$estimate[2])})
  print(paste(i, "SPC", lapply(fit.distr, function(i){i$estimate}), sep = ": "))
  print(paste(i, "LES", lapply(fit.les.distr, function(i){i$estimate}), sep = ": "))
}


# plot histograms and fitted pdf ------------------------------------------------------------------
# Figure 3

# breaks for histograms
br.spc = c(br[1:(length(br)-1)],500)
br.les = c(0,seq(1,36,7),br[2:(length(br)-1)],seq(489,800,7),10000)
# midpoints
x.mids.spc = (br.spc[-length(br.spc)] + br.spc[-1]) / 2
x.mids.les = (br.les[-length(br.les)] + br.les[-1]) / 2
ymax = max(do.call(c, lapply(spc.density, function(i){ sapply(i, max) })))

pdf(file = "PSD_S17_SPC_LES_cases1-3a_dx10cm_350-750s.pdf", width = 9, height = 4)
op = par(mar = c(0.4,0.4,1,1), oma = c(3.9,4.5,0,0), mfrow=c(2,2))#, family = "sans")
for(i in 1:length(spc.density)){
  my.j = if(i == 1){ c(2,1) }else{ 1 }
  for(j in my.j){
    # ymax = max(max(spc.density[[i]][[j]]),max(les.density[[i]][[j]]))
    spc_hist = structure(list(density = spc.density[[i]][[j]], mids = x.mids.spc, breaks = br.spc), class = "histogram")
    les_hist = structure(list(density = les.density[[i]][[j]], mids = x.mids.les, breaks = br.les), class = "histogram")
    plot(spc_hist, xlab = "", ylab = "", main = "", xlim = c(0,600), 
         xaxt = "n", yaxt = "n", col = rgb(0.95,0.95,0, alpha = 0.8), ylim = c(0,ymax))
    axis(side = 1, labels = if(i > 1){T}else{F})
    axis(side = 2, labels = if(j == 2 | i == 2){T}else{F})
    if((i == 1 & j == 2) | i == 2){
      title(ylab = expression(Density~(mu*m^{-1})), xpd = NA)
    }
    box()
    plot(les_hist, add = T, col = rgb(0.39,0.58,1, alpha = 0.5))
    lines(x1, spc.dens.fit[[i]][[j]], col = 2)
    lines(x2, les.dens.fit[[i]][[j]], col = "darkblue")
    if(i == 1 & j == 2) legend("topright", legend = c("Measurement","Fit to measurement","Simulation","Fit to simulation"), fill = c(rgb(0.95,0.95,0, alpha = 0.8), NA, rgb(0.39,0.58,1, alpha = 0.5),NA), border = c(1,"white",1,"white"), lty = c(NA,1,NA,1), col= c(NA,2,NA,"darkblue"))
    lab.sub   = if(i==1 & j==1){ "b" }else{ c("a","c","d")[i] }
    lab.sub.2 = if(i==1 & j==1){ expression("Case 1, "*italic(z)*" = 0.15 m") }else{ expression("Case 1, "*italic(z)*" = 0.1 m","Case 2, "*italic(z)*" = 0.1 m","Case 3a, "*italic(z)*" = 0.1 m")[i] }
    x.sub.2   = if(i==1 & j==2){ 100 }else{ 140 }
    text(x = 15, y = 0.95*ymax, labels = lab.sub, font = 2)
    text(x = x.sub.2, y = 0.95*ymax, labels = lab.sub.2, adj = c(0,0.5))
    if(i %in% c(2,3)){ title(xlab = expression(italic(d[p])~(mu*m)), xpd = NA) }
  }      #mtext(text = expression(italic(d[p])~("\u03BC"*m)), side = 1, line = 3)}
}
dev.off()


# save distribution data to file for (Envidat repository) ------------------------------------------------------------------

na.meas.pre = rep(NA,4)
dp_meas = c(na.meas.pre, br.spc[-length(br.spc)])
dp_LES = br.les[-c(1,2,length(br.les))]
na.meas.post = rep(NA,length(dp_LES)-length(dp_meas))
dp_meas = c(dp_meas, na.meas.post)
spc.result = list(spc.density[[1]][[2]], spc.density[[1]][[1]], spc.density[[2]][[1]], spc.density[[3]][[1]])
f_meas = sapply(spc.result, function(i){ round(c(na.meas.pre, i, na.meas.post), digits = 8) })
colnames(f_meas) = c("f_meas_case1_10cm","f_meas_case1_15cm","f_meas_case2_10cm","f_meas_case3_10cm")
les.result = list(les.density[[1]][[2]], les.density[[1]][[1]], les.density[[2]][[1]], les.density[[3]][[1]])
f_LES = sapply(les.result, function(i){ round(i[-(1:2)], digits = 8) })
colnames(f_LES) = c("f_LES_case1_10cm","f_LES_case1_15cm","f_LES_case2_10cm","f_LES_case3a_10cm")
df.out = cbind.data.frame(dp_meas, dp_LES, f_meas, f_LES)
write.csv(df.out, file = paste("Fig_3_size_distribution.csv",sep=""), na = "NaN", row.names = F)
