# Script used in read_plot_LES_output.R

# label of grid layer for each parcel
for(i in 1:length(ptcl)){
  ptcl[[i]]$layer = findInterval(ptcl[[i]]$z_p, bound) #sapply(ptcl[[i]]$z_p, function(x){sum(!(x <= bound))})
}
# For some variables (like T and q forcings), summarize labels of first two layers (representing the layer of the first uvp node above the surface) to include forcing of particles below entrainment height.
layer_p = ptcl$tp1$layer
layer_p[which(ptcl$tp1$layer == min(ptcl$tp1$layer))] = min(ptcl$tp1$layer) + 1

# indexes of layers covered by data
ind.col   = 1 + sort(unique(ptcl$tp1$layer))
ind.col_p = sort(unique(layer_p))
# total particle mass per layer
agg = extract_profile_from_particles(data = ptcl$tp1$mass_p, INDEX = list(time = ptcl$tp1$jt_total, layer = ptcl$tp1$layer),
                                     ind.column = ind.col, default = 0, ncol = length(bound), with.time = T)
# divide by volume to get particle mass concentration (kg m-3) and exclude lowest layer because entrained particles are initialized at the top of this layer
mass.conc = agg[[1]][-1] / (L_X*L_Y*diff(bound))
# total particle mass per layer as function of time
mass_p_sum = agg[[2]]
# exclude lowest layer and divide by volume
mass.conc.with.time = t( apply(mass_p_sum[,-1], MARGIN = 1, function(x){ x / (L_X*L_Y*diff(bound)) }) )

# total particle number per layer
agg = extract_profile_from_particles(data = ptcl$tp1$ppp, INDEX = list(time = ptcl$tp1$jt_total, layer = ptcl$tp1$layer),
                                     ind.column = ind.col, default = 0, ncol = length(bound), with.time = T)
# number concentration (m-3) # exclude lowest layer because entrained particles are initialized at the top of this layer
number.conc = agg[[1]][-1] / (L_X*L_Y*diff(bound))
# total particle number per layer as function of time
number_p_sum = agg[[2]]

# number of parcels (not total number of particles)
agg = extract_profile_from_particles(data = is.finite(ptcl$tp1$d_p), INDEX = list(time = ptcl$tp1$jt_total, layer = ptcl$tp1$layer),
                                     ind.column = ind.col, default = 0, ncol = length(bound), with.time = T)
# parcel number per layer as function of time
number_parcels_sum = agg[[2]]

# mean particle diameter (m) per layer and time
agg = extract_profile_from_particles(data = ptcl$tp1$ppp * ptcl$tp1$d_p, INDEX = list(time = ptcl$tp1$jt_total, layer = ptcl$tp1$layer),
                                     ind.column = ind.col, normaliz.matrix = number_p_sum, default = NA, ncol = length(bound), with.time = T)
d_p_mean_per_t_z = agg[[2]]
# exclude lowest layer because entrained particles are initialized at the top of this layer
d_p_mean = agg[[1]][-1]

time.ptcl.min   = time.ptcl[1]
delta.time.ptcl = diff(time.ptcl[1:2])
# mean particle diameter for time and layer, to which the particle of interest belongs to
for(i in 1:length(ptcl)){
  ptcl[[i]]$t.index          = ( ptcl[[i]]$jt_total * DT - time.ptcl.min ) / delta.time.ptcl + 1
  ptcl[[i]]$d_p_mean_per_t_z = sapply(1:NROW(ptcl[[i]]), function(x){ d_p_mean_per_t_z[ ptcl[[i]]$t.index[x], ptcl[[i]]$layer[x] + 1 ] })
}
# variance of particle diameter (m2) per layer and time
agg = extract_profile_from_particles(data = ptcl$tp1$ppp * (ptcl$tp1$d_p - ptcl$tp1$d_p_mean_per_t_z)^2, INDEX = list(time = ptcl$tp1$jt_total, layer = ptcl$tp1$layer),
                                     ind.column = ind.col, normaliz.matrix = number_p_sum - 1, default = NA, ncol = length(bound), with.time = T)
# exclude bins with less than 3 parcels
in.exclude = which(number_parcels_sum < 3)
agg[[2]][in.exclude] = NA
# average over time
var.tmp = apply( agg[[2]], 2, mean, na.rm = T )
# standard deviation of particle diameter (m) per layer, exclude lowest layer because entrained particles are initialized at the top of this layer
d_p_sigma = sqrt( var.tmp[-1] )
# d_p_sigma = sqrt( agg[[1]][-1] )

# mass-weighted mean particle velocity in x direction per layer and time
agg = extract_profile_from_particles(data = ptcl$tp1$u_p * ptcl$tp1$mass_p, INDEX = list(time = ptcl$tp1$jt_total, layer = ptcl$tp1$layer),
                                     ind.column = ind.col, normaliz.matrix = mass_p_sum, default = NA, ncol = length(bound), with.time = T)
u_p_mean = agg[[1]][-1]
u_p_mean_with_time = agg[[2]][,-1]

# horizontal particle mass flux (kg m s^-1) per layer and point in time
agg = extract_profile_from_particles(ptcl$tp1$mass_p * ptcl$tp1$u_p, INDEX = list(time = ptcl$tp1$jt_total, layer = ptcl$tp1$layer),
                                     ind.column = ind.col, default = 0, ncol = length(bound), with.time = T)
# exclude lowest layer, divide by volume, and convert units (kg m^-2 min^-1)
mass_hflux = agg[[1]][-1] / (L_X*L_Y*diff(bound)) * 60
hflux_with_time = t( apply(agg[[2]][,-1], MARGIN = 1, function(x){ x / (L_X*L_Y*diff(bound)) * 60 }) )
# transport rate as a function of time (kg m-1 min-1)
transport = apply(hflux_with_time, 1, function(x){ sum( x * diff(bound) ) })

# horizontal particle number flux (m^-2 s^-1) per layer and point in time
agg = extract_profile_from_particles(ptcl$tp1$ppp * ptcl$tp1$u_p, INDEX = list(time = ptcl$tp1$jt_total, layer = ptcl$tp1$layer),
                                     ind.column = ind.col, default = 0, ncol = length(bound), with.time = T)
# exclude lowest layer, divide by volume, and convert units (cm^-2 s^-1)
number_hflux = agg[[1]][-1] / (L_X*L_Y*diff(bound)) / 10000
number_hflux_with_time = t( apply(agg[[2]][,-1], MARGIN = 1, function(x){ x / (L_X*L_Y*diff(bound)) / 10000 }) )

# humidity forcing of particles (kg s^-1) per layer and point in time
agg = extract_profile_from_particles(- ptcl$tp1$ppp * ptcl$tp1$delta_m, INDEX = list(time = ptcl$tp1$jt_total, layer = layer_p),
                                     ind.column = ind.col_p, default = 0, ncol = length(bound[-1]), with.time = T)
# divide by mass of air, and convert units (g kg^-1 s^-1)
FQ_p           = agg[[1]] / ( rho_air * L_X*L_Y*diff(c(0,bound[-1])) ) * 1000
FQ_p_with_time = t( sapply(1:NROW(agg[[2]]), function(i){ agg[[2]][i,] / ( rho_air * L_X*L_Y*diff(c(0,bound[-1])) ) * 1000 }) )
# linearly interpolate air temperature (or if time is outside the period with known temperature, use value of closest time)
t.air.inter = apply( coredata(avg$t), 2, function(i){ approx(x = time(avg$t), y = i, xout = time.ptcl, rule = 2)$y } )
# latent heat of sublimation per layer and time (formula as in LES)
Lv.ptcl     = apply(t.air.inter, 2, Lsubl)
# latent heat source/sink (W m^-3)
S.latent       = t( sapply(1:NROW(agg[[2]]), function(i){ agg[[2]][i,] * Lv.ptcl[i,] / ( L_X*L_Y*diff(c(0,bound[-1])) ) }) )
# latent heat exchange (W m^-2)
exchange.latent = apply(S.latent, 1, function(x){ sum( x * diff(c(0,bound[-1])) ) })

# 1D index for t.air.inter matrix (rowIndex + )
in1D = match(ptcl$tp1$jt_total, round(time.ptcl / DT)) + NROW(t.air.inter) * (layer_p - 1)
# latent heat of sublimation (formula as in LES)
ptcl$tp1$Lv = Lsubl(temp = t.air.inter[in1D])
# temperature forcing of particles due to sensible heat transfer (J s^-1)
ptcl$tp1$q_conv = (ptcl$tp1$delta_T * t_scale - 3 * ptcl$tp1$Lv * 2 / (ptcl$tp1$d_p * c_L) * ptcl$tp1$delta_r) * c_L * (P_RHO*pi*ptcl$tp1$d_p^3 / 6)
# per layer and point in time
agg = extract_profile_from_particles(- ptcl$tp1$ppp * ptcl$tp1$q_conv, INDEX = list(time = ptcl$tp1$jt_total, layer = layer_p),
                                     ind.column = ind.col_p, default = 0, ncol = length(bound[-1]), with.time = T)
# divide by mass of and specific heat capacity of air (K s^-1)
Ft_p_1           = agg[[1]] / ( rho_air * L_X*L_Y*diff(c(0,bound[-1])) * c_p_a )
Ft_p_1_with_time = t( sapply(1:NROW(agg[[2]]), function(i){ agg[[2]][i,] / ( rho_air * L_X*L_Y*diff(c(0,bound[-1])) * c_p_a ) }) )

# T at particle surface minus T of air (K)
ptcl$tp1$t.diff = (ptcl$tp1$delta_T * t_scale - 3 * ptcl$tp1$Lv * 2 / (ptcl$tp1$d_p * c_L) * ptcl$tp1$delta_r) / (-1/3 * ptcl$tp1$nu_p / PR_SC1 * c_p_a / c_L / ptcl$tp1$timescale_stokes)
# temperature forcing of particles due to temperature change of water that changes the phase (J s^-1)
ptcl$tp1$q_evap = ptcl$tp1$delta_m * c_p_v * (- ptcl$tp1$t.diff)
# per layer and point in time during period tp1
agg = extract_profile_from_particles(- ptcl$tp1$ppp * ptcl$tp1$q_evap, INDEX = list(time = ptcl$tp1$jt_total, layer = layer_p),
                                     ind.column = ind.col_p, default = 0, ncol = length(bound[-1]), with.time = T)
# divide by mass of and specific heat capacity of air (K s^-1)
Ft_p_2           = agg[[1]] / ( rho_air * L_X*L_Y*diff(c(0,bound[-1])) * c_p_a )
Ft_p_2_with_time = t( sapply(1:NROW(agg[[2]]), function(i){ agg[[2]][i,] / ( rho_air * L_X*L_Y*diff(c(0,bound[-1])) * c_p_a ) }) )

# mass-weighted mean T difference between particles and air per time and layer
agg = extract_profile_from_particles(ptcl$tp1$mass_p * ptcl$tp1$t.diff, INDEX = list(time = ptcl$tp1$jt_total, layer = ptcl$tp1$layer),
                                     ind.column = ind.col, normaliz.matrix = mass_p_sum, default = NA, ncol = length(bound))
# exclude lowest layer
t.diff.layer = agg[-1]

# q at particle surface minus q of air (g/kg)
ptcl$tp1$q.diff = -ptcl$tp1$delta_r * 9 * PR_SC2 / ptcl$tp1$sh_p * ptcl$tp1$timescale_stokes / (0.5 * ptcl$tp1$d_p) * 1000
# mass-weighted mean q difference between particles and air per time and layer
agg = extract_profile_from_particles(ptcl$tp1$mass_p * ptcl$tp1$q.diff, INDEX = list(time = ptcl$tp1$jt_total, layer = ptcl$tp1$layer),
                                     ind.column = ind.col, normaliz.matrix = mass_p_sum, default = NA, ncol = length(bound))
# exclude lowest layer
q.diff.layer = agg[-1]

# particle forcing on momentum is not calculated because it would require the particle acceleration and thus the relative velocity between particle and air

# sum of mass times particle temperature per layer and point in time
agg = extract_profile_from_particles(ptcl$tp1$mass_p * ptcl$tp1$T_p, INDEX = list(time = ptcl$tp1$jt_total, layer = ptcl$tp1$layer),
                                     ind.column = ind.col, normaliz.matrix = mass_p_sum, default = NA, ncol = length(bound), with.time = T)
# exclude lowest layer
T_p_mean           = agg[[1]][-1] * t_scale - 273.15
T_p_mean_with_time = agg[[2]][,-1]* t_scale - 273.15
