# Configuration file: 10 min averages of measurements at S17, measured on 11 January 2019 between 00:40 and 00:50 UTC

# measured friction velocity (m/s)
# ustar_expected =  0.8536 # 0.662

# measurements
meas = list(u   = c(11.34, 12.11, 13.12),       # wind speed (m/s)
            z.u = c(1, 1.9, 3),                 # height (m)
            t   = c(-5.63, -4.57, -4.83),       # temperature (degC)
            z.t = c(0, 1, 1.9),
            q   = c(0.002614, 0.002553) * 1000, # specific humidity (g/kg)
            z.q = c(0, 1),
            rh  = 90,                           # relative humidity (%)
            z.rh= 1,
            spc.flux = c(6.82, 18.48),          # snow mass flux (kg/(m^2*min))        as determined in compare_size_distribution_SPC_LES.R
            spc.number.flux = c(2213, 3874),    # snow particle number flux (cm-2 s-1) as determined in compare_size_distribution_SPC_LES.R
            z.spc = c(0.15, 0.1))
# measurement uncertainty
unc = list(u = c(0.3, 0.3, 0.3),
           t = c(0.2, 0.9, 1),
           q = c(0.00004, 0.00021) * 1000,
           rh = 4)

# measured latent heat flux (W/m^2) according to the Eddy covariance method (at z = 1.9 m) and the Monin-Obukhov bulk approach (considering the layer between z = 0 m and z = 1 m)
#ql.meas = data.frame(EC = 35.2, MO = 2.5) # for z0T = z0q = z0
#ql.meas = data.frame(EC = 35.2, MO = 1.6) # for z0q = 0.01*z0 and z0T = 0.1*z0
ql.meas = data.frame(EC = 35.2, MO = 2.3) # for z0Andreas
# uncertainty of MO bulk latent heat flux (W/m^2) due to instrument uncertainties in T_air, T_surf, RH, and u
# ql.unc.MO = 15.4 #11.7 # for z0T = z0q = z0
#ql.unc.MO = 10.2 # for z0q = 0.01*z0 and z0T = 0.1*z0
ql.unc.MO = 14.2 # for z0Andreas

# measured sensible heat flux (W/m^2) according to the Eddy covariance method (at z = 1.9 m) and the Monin-Obukhov bulk approach (considering the layer between z = 0 m and z = 1 m)
# qh.meas = data.frame(EC = -65.4, MO = -26.9) # for z0T = z0q = z0
#qh.meas = data.frame(EC = -65.4, MO = -21.6) # for z0T = 0.1*z0 and z0q = 0.01*z0
qh.meas = data.frame(EC = -65.4, MO = -24.8) # for z0Andreas
# uncertainty of MO bulk sensible heat flux (W/m^2) due to instrument uncertainties in T_air, T_surf, and u
# qh.unc.MO = 23.49 #17.9 # for z0T = z0q = z0
#qh.unc.MO = 18.8 # for z0T = 0.1*z0 and z0q = 0.01*z0
qh.unc.MO = 21.4 # for z0Andreas

# momentum flux (N/m^2) according to the Eddy covariance method (at z = 1.9 m) and the Monin-Obukhov bulk approach (considering the layer between z = 0 m and z = 1 m)
tau.meas = data.frame(EC = -0.272, MO = -0.287) # identical for both options for z0T and z0q
# uncertainty of MO bulk momentum flux (N/m^2) due to instrument uncertainties in u
tau.unc.MO = 0.015 # identical for all options for z0T and z0q
