# Configuration file: 10 min averages of measurements at S17, measured on 11 January 2019 between 21:40 and 21:50 UTC


# measurements
meas = list(u   = c(14.51,15.205,16.45),        # wind speed (m/s)
            z.u = c(1, 1.9, 3),                 # height (m)
            t   = c(-4.44,-4.65,-5.04),         # temperature (degC)
            z.t = c(0, 1, 1.9),
            q   = c(0.002881, 0.002865) * 1000, # specific humidity (g/kg)
            z.q = c(0, 1),
            rh  = 101.2,                        # relative humidity (%)
            z.rh= 1,
            spc.flux = c(0.03, 12.27),          # snow mass flux (kg/(m^2*min))        as determined in compare_size_distribution_SPC_LES.R
            spc.number.flux = c(114, 6028),     # snow particle number flux (cm-2 s-1) as determined in compare_size_distribution_SPC_LES.R
            z.spc = c(0.15, 0.1))
# measurement uncertainty
unc = list(u = c(0.3, 0.3, 0.3),
           t = c(0.2, 0.9, 1),
           q = c(0.000044, 0.000264) * 1000,
           rh = 6)

# measured latent heat flux (W/m^2) according to the Eddy covariance method (at z = 1.9 m) and the Monin-Obukhov bulk approach (considering the layer between z = 0 m and z = 1 m)
ql.meas = data.frame(EC = -27.8, MO = 1.3)
# uncertainty of MO bulk latent heat flux (W/m^2) due to instrument uncertainties in T_air, T_surf, RH, and u
ql.unc.MO = 22.1

# measured sensible heat flux (W/m^2) according to the Eddy covariance method (at z = 1.9 m) and the Monin-Obukhov bulk approach (considering the layer between z = 0 m and z = 1 m)
qh.meas = data.frame(EC = -27.8, MO = 6.0)
# # uncertainty of MO bulk sensible heat flux (W/m^2) due to instrument uncertainties in T_air, T_surf, and u
qh.unc.MO = 26.6

# momentum flux (N/m^2) according to the Eddy covariance method (at z = 1.9 m) and the Monin-Obukhov bulk approach (considering the layer between z = 0 m and z = 1 m)
tau.meas = data.frame(EC = -0.393, MO = -0.468)
# uncertainty of MO bulk momentum flux (N/m^2) due to instrument uncertainties in u
# tau.unc.MO = 
