# Configuration file: 10 min averages of measurements at S17, measured on 12 January 2019 between 11:00 and 11:10 UTC


# measurements
meas = list(u   = c(10.86,11.3572,12.16),       # wind speed (m/s)
            z.u = c(1, 1.9, 3),                 # height (m)
            t   = c(-2.77,-3.40,-4.106),        # temperature (degC)
            z.t = c(0, 1, 1.9),
            q   = c(0.003297, 0.003101) * 1000, # specific humidity (g/kg)
            z.q = c(0, 1),
            rh  = 99.0,                         # relative humidity (%)
            z.rh= 1,
            spc.flux = c(0, 11.27),             # snow mass flux (kg/(m^2*min))        as determined in compare_size_distribution_SPC_LES.R
            spc.number.flux = c(0, 4234),       # snow particle number flux (cm-2 s-1) as determined in compare_size_distribution_SPC_LES.R
            z.spc = c(0.15, 0.1))
# measurement uncertainty
unc = list(u = c(0.3, 0.3, 0.3),
           t = c(0.2, 0.9, 1),
           q = c(0.00005, 0.000285) * 1000,
           rh = 6)

# measured latent heat flux (W/m^2) according to the Eddy covariance method (at z = 1.9 m) and the Monin-Obukhov bulk approach (considering the layer between z = 0 m and z = 1 m)
ql.meas = data.frame(EC = 18.4, MO = 13.0)
# uncertainty of MO bulk latent heat flux (W/m^2) due to instrument uncertainties in T_air, T_surf, RH, and u
ql.unc.MO = 18.6

# measured sensible heat flux (W/m^2) according to the Eddy covariance method (at z = 1.9 m) and the Monin-Obukhov bulk approach (considering the layer between z = 0 m and z = 1 m)
qh.meas = data.frame(EC = -4.2, MO = 14.1)
# # uncertainty of MO bulk sensible heat flux (W/m^2) due to instrument uncertainties in T_air, T_surf, and u
qh.unc.MO = 20.7

# momentum flux (N/m^2) according to the Eddy covariance method (at z = 1.9 m) and the Monin-Obukhov bulk approach (considering the layer between z = 0 m and z = 1 m)
tau.meas = data.frame(EC = -0.231, MO = -0.263)
# uncertainty of MO bulk momentum flux (N/m^2) due to instrument uncertainties in u
# tau.unc.MO = 
