# Script defining the simulation (LES-LM) characteristics used as an input for fitting a linear regression model to the temperature change of particles

# ustar (m s-1), estimated from slope of linear regression between mean wind speed and logarithm of height (z between 0.5 and 4 m) in conditions of drifting/blowing snow
ustar = rbind(c(0.623, 0.593), # case 1
              c(0.568, 0.603), # case 2
              c(0.827, 0.791), # case 3a
              c(0.841, 0.793)) # case 3b
# T(z=7.5mm) minus T(0) in units of K for 200s periods during quasi-steady state
delta.t.air = rbind(c( 0.426,   0.441), # case 1
                    c(-0.383,  -0.400), # case 2
                    c(-0.0850, -0.0849), # case 3a
                    c( 0.264,   0.267)) # case 3b
# relative humidity (%) at z = 7.5 mm for 200s periods during quasi-steady state
rh      = rbind(c(97.69, 97.47), # case 1
                c(99.84, 99.83), # case 2
                c(99.99, 99.99), # case 3a
                c(99.97, 99.97)) # case 3b

