# Function for calculating height of saltation layer (m)

# method     Either "pomeroy_male" or "lehning"
# ustar      friction velocity (m s-1)
# z0         momentum roughness length (m)

calc_h_salt = function(method, ustar, z0 = 1e-4){
  if(method == "pomeroy_male"){
    0.08436 * ustar^1.27 #  Pomeroy and Male, 1992
  } else{
    if(method == "lehning"){
      z0 + (3.1 * ustar * cos(25/180*pi))^2 / (4*9.81) # Lehning et al., 2008
    } else{
      stop("Specified method in calc_h_salt is not implemented.")
    }
  }
}


# Example --------------------------------------------------------------------

# ustar = seq(0, 1, 0.01)
# z0    = 1e-4
# h_salt_pm = calc_h_salt(method = "pomeroy_male", ustar = ustar, z0 = z0)
# h_salt_l  = calc_h_salt(method = "lehning", ustar = ustar, z0 = z0)
# ylims = range(c(h_salt_pm, h_salt_l))
# plot(ustar, h_salt_l, type = "l", ylim = ylims, xlab = expression(u["*"]~(m~s^{-1})), ylab = expression(h[salt]~(m)))
# axis(side = 4, labels = F)
# lines(ustar, h_salt_pm, col = 2)
# legend("topleft", legend = c("Pomeroy and Male","Lehning et al., z0 = 1e-4 m"), col = 1:2, lty = 1)
