# Function for computing the shape parameter of a gamma distribution of particle size for given mass mixing ratios, number mixing ratios, and mean particle diameters

get_alpha = function(qi, qni, dp, rho_p = 918.0, alpha_test = seq(0.1,30,0.1)){
  alpha_LES = sapply(1:length(qi), function(i){
    # rate parameter of gamma distribution
    lambda_test = alpha_test / dp[i] # m-1
    # drifting snow number mixing ratio (kg-1)
    qn_test = qi[i] * lambda_test^3 * 6 / (pi*rho_p) * gamma(alpha_test) / gamma(alpha_test+3)
    in.min = which.min(abs(qn_test - qni[i]))
    alpha_test[in.min]
  })
  if(min(alpha_LES) == min(alpha_test) | max(alpha_LES) == max(alpha_test)){
    warning('In get_alpha: Min or max of tested range is reached.')
  }
  return(alpha_LES)
}
