# Function for reading ta1 binary files from LES output

# dim.field:     matrix specifying the x, y, z dimensions of the field; the rows refer to MPI processes from 0 to the 'number of processes - 1'
# single.proc:   Either NA (all subdomains are read) or a single integer from 0 to 'NROW(dim.field)-1' (only that subdomain is read)  

# read binary files from LES output
read_binary_LES_output = function(vname, path, n.time, dim.field, single.proc = NA){
  if(is.na(single.proc)){
    proc = 0:(NROW(dim.field)-1)
  } else{
    proc = single.proc
  }
  for(i in proc){
    fn_curr = file.path(path, paste(vname, ".c", as.character(i), sep = ""))
    if(i==0){
      print(paste("Reading", vname))
    }
    to.read = file(fn_curr, "rb")
    data = readBin(con = to.read, what = double(), n = n.time*prod(dim.field[i+1,]))
    close(to.read)
    # number of times (averaged fields)
    nt = length(data) / prod(dim.field[i+1,])
    # build an array from the data
    tmp = array(data = data, dim = c(dim.field[i+1,], nt))
    
    # allocate global array
    if(is.na(single.proc)){
      if(i == 0){dat = array(data = NA, dim = c(dim.field[1,1], dim.field[1,2], sum(dim.field[,3]), nt))}
      # global array
      dat[, , (1:dim.field[i+1,3]) + if(i==0){ 0 } else{ sum(dim.field[1:i,3]) }, ] = tmp
    } 
  }
  
  if(is.na(single.proc)){
    return(dat)
  } else{
    return(tmp)
  }
}
