# Script used in 1_read_proc_LES_output.R

#pdf(file = file.path(path, "ts_fluxes_at_boundaries.pdf"), width = 10, height = 8)
par(mfrow = c(3,1), mar = c(5,5,1,1))

# friction velocity 
plot(xstar$ustar, ylab = expression(u["*"]~(m~s^{-1})), xlab = "Time (s)", ylim = c(0,max(xstar$ustar,na.rm=T)))
abline(v = LSM_INIT*DT, col= "darkgrey")
abline(h=0, lty = 2)
#abline(h = ustar_expected, lty = 2, col= "darkgrey")
legend("topright", legend = c(as.expression(bquote(u["*"]~(.(round(mean(xstar$ustar[I(t.stnry)]),2))~m~s^{-1}~after~.(t.start.stnry)~s)))),
       title = "Lower boundary", col = 1, lty = 1)
# dev.off()

ylims = range(c(coredata(ql_surf), coredata(qh_surf), 0), na.rm = T)
plot(ql_surf, ylab = expression(Q~(W~m^{-2})), xlab = "Time (s)", ylim = ylims)
abline(v = LSM_INIT*DT, col= "darkgrey")
lines(qh_surf, col = 2)
abline(h=0, lty = 2)
legend("topright", legend = c(as.expression(bquote(Q[L]~(.(round(boundary.flux.avg$ql_surf,1))~W~m^{-2}~after~.(t.start.stnry)~s))),
                              as.expression(bquote(Q[H]~(.(round(boundary.flux.avg$qh_surf,1))~W~m^{-2}~after~.(t.start.stnry)~s)))), 
       title = "Lower boundary", col = 1:2, lty = 1)
# dev.off()

ylims = range(c(coredata(ql_ub), coredata(qh_ub), 0), na.rm=T)
plot(ql_ub, ylab = expression(Q~(W~m^{-2})), xlab = "Time (s)", ylim = ylims)
abline(v = LSM_INIT*DT, col= "darkgrey")
lines(qh_ub, col = 2)
abline(h=0, lty = 2)
legend("topright", legend = c(as.expression(bquote(Q[L]~(.(round(boundary.flux.avg$ql_ub,1))~W~m^{-2}~after~.(t.start.stnry)~s))),
                              as.expression(bquote(Q[H]~(.(round(boundary.flux.avg$qh_ub,1))~W~m^{-2}~after~.(t.start.stnry)~s)))), 
       title = "Upper boundary", col = 1:2, lty = 1)

# dev.off()

