# Script used in read_plot_LES_output.R

# read text files ----------------------------------------------------------
# horizontally averaged instantaneous friction velocity (m/s), humidity scale (qstar in units of humidity), temperature scale (tstar in K/t_scale) at the surface, and latent and sensible heat fluxes at the upper boundary
xstar = lapply(file.path(path, paste(fn, "_0.txt", sep = "")), read.table)
names(xstar) = fn
# head(xstar[[1]])
# convert to zoo object with the time since the beginning (s)
xstar = lapply(xstar, zoo, seq(t.start + WBASE * DT, by = WBASE * DT, length.out = nrow(xstar$ustar)))
# tail(ustar)

# plot fluxes at the surface and the upper boundary -----------------------------------
# latent heat flux "through" surface (W/m^2) # positive: upward flux
ql_surf = - Lsubl(temp = DLBC_SC1*t_scale-273.15) * rho_air * xstar$qstar * xstar$ustar
# sensible heat flux "through" surface (W/m^2)
qh_surf = - rho_air * c_p_a * xstar$tstar * t_scale * xstar$ustar

# fluxes at the upper boundary 
# SGS latent heat flux "through" upper boundary (W/m^2) # positive: upward flux # assume same latent heat of sublimation as at the surface
in.flux = which(names(xstar) %in% c("q_flux_upper_boundary","q_sgsFluxUpperBoundary"))
ql_ub = - Lsubl(temp = DLBC_SC1*t_scale-273.15) * rho_air * xstar[[5]]
# SGS sensible heat flux "through" upper boundary (W/m^2)
in.flux = which(names(xstar) %in% c("t_flux_upper_boundary","t_sgsFluxUpperBoundary"))
qh_ub = - rho_air * c_p_a * xstar[[in.flux]] * t_scale
## discard UBC fluxes during 3 s after each restart
# determine times of restart
# restart.names = list.files(path, pattern = "some_output")
# restart.names = strsplit(restart.names, "-")
# restart.names = lapply(restart.names, function(i){ substr(i[2], start = 1, stop = nchar(i[2])-1) })
# t.restart     = as.numeric(restart.names) * 1000 * DT
# for(i in 1:length(t.restart)){
#   window(ql_ub, start = I(t.restart[i]), end = I(t.restart[i]+3)) = NA
#   window(qh_ub, start = I(t.restart[i]), end = I(t.restart[i]+3)) = NA
# }

# times with quasi-stationary sublimation rate (after a given point in time)
t.stnry = time(xstar$ustar)[which(time(xstar$ustar) > t.start.stnry)]
# mean sensible and latent heat fluxes and friction velocity at the boundaries during quasi-stationary phase (W m^-2)
boundary.flux.avg = list(qh_surf = mean(qh_surf[I(t.stnry)]),
                         qh_ub   = mean(qh_ub[I(t.stnry)], na.rm = T),
                         ql_surf = mean(ql_surf[I(t.stnry)]),
                         ql_ub   = mean(ql_ub[I(t.stnry)], na.rm = T),
                         ustar_surf = mean(xstar$ustar[I(t.stnry)]))

