# Script used in read_plot_LES_output.R

mb_file = list.files(path = file.path(path, "output_0/lsm/"), pattern = "mass_balance.txt", full.names = T)
if(length(mb_file) == 0){
  print("mass_balance.txt file not found.")
} else{
  print(paste("Reading", mb_file,"and plotting..."))
  
  # read mass_balance.txt ---------------------------------------------------
  massbal = read.table(file.path(path, "output_0/lsm/mass_balance.txt"), header = tf.header)
  if(!tf.header) colnames(massbal) = c("time","u_star2","entrain_flux","depo_flux","splash_flux","suspension")
  # extract fluxes and correct units if necessary (kg m-2 s-1)
  massbal_fluxes = massbal[,3:5] #* PRINT1_FREQ / (diff(massbal[1:2,1])/DT)
  massbal_fluxes = zoo(massbal_fluxes, massbal[,1] + LSM_INIT*DT)
  # mass aloft (kg m-2)
  massbal_aloft = zoo( cumsum(apply(coredata(massbal_fluxes), 1, sum) * diff(time(massbal_fluxes)[1:2])), time(massbal_fluxes) )
  
  # plot entrainment/deposition fluxes and mass aloft
  #pdf(file = file.path(path, "ts_entrain_depo_fluxes.pdf"), width = 10, height = 6)
  par(mfrow = c(2,1), mar = c(0.5,5,1,1), oma = c(4.5,0,0,0))
  plot(massbal_fluxes[,c(1,3)], screens = c(1,1), col = 1:2, ylim = range(abs(massbal_fluxes)), xlab = "", ylab = expression(Flux~(kg~m^{-2}~s^{-1})), xaxt = "n")
  axis(1, labels = F)
  lines(-massbal_fluxes[,2], col = 4)
  abline(h=0,lty=2)
  legend("top", inset = c(0,-0.1), legend = c("Aerodynamic entrainment","Splash entrainment","Deposition"), col = c(1,2,4), lty = 1, horiz = T, xpd = NA, cex = 0.8)
  plot(massbal_aloft, ylab = expression(Mass~aloft~(kg~m^{-2})), xlab = "Time (s)", xpd = NA)
  #dev.off()
}

