# Script used in read_plot_LES_output.R

# read simulation parameters for ta1 field -------------------------------------------

param = read.table(file = file.path(path, "output_0/ta1_field/parameters.txt"), dec = ".")
param = param[,1]
if(NROW(param) > 20){
  nz_vector = param[21:NROW(param)]
}
param = data.frame(nx=param[1], ny=param[2], nz=param[3], # remember that nz is nz_tot-1!! 
                   lx=param[4], ly=param[5], lz=param[6],
                   dx=param[7], dy=param[8], dz=param[9],
                   nt=param[10], mpiProc=param[11],
                   Re=param[12], Ri=param[13], Pr=param[14],
                   katAngle=param[15], sgs=param[16], sc1=param[17],
                   sc2=param[18], ibm=param[19], phiRot=param[20])
param$nzi = param$nz / param$mpiProc
# read heights
if("uvpheight.log" %in% list.files(path = path)){
  print("Reading 'uvpheight.log'.")
  # read heights (m) for uvp nodes
  height = read.table(file = file.path(path, "uvpheight.log"), dec = ".")
  # extract heights contained in the ta1 output (at uvp nodes)
  z      = height[1:(nrow(height)-1), 2]
  # read heights (m) for w nodes
  height = read.table(file = file.path(path, "wheight.log"), dec = ".")
  # heights of w nodes, incl. lower and upper boundary
  z.w    = height[,2]
} else{
  warning("uvpheight.log file not found.")
}
# ta1 field dimensions, one row per MPI process
nz.ta1 = if(exists("nz_vector")){ nz_vector - 1 } else{ rep(param$nzi, param$mpiProc) }
if(HAVG_CNT3){
  nx.ta1 = 1 
  ny.ta1 = 1
} else{
  nx.ta1 = param$nx
  ny.ta1 = param$ny
}
dim.ta1 = cbind(rep(nx.ta1, param$mpiProc), rep(ny.ta1, param$mpiProc), nz.ta1)


# read files-----------------------------------------------------------------------

dat = lapply(varnames, read_binary_LES_output, path = file.path(path, "output_0/ta1_field/"), n.time = n.fields, dim.field = dim.ta1)
names(dat) = varnames
# average vertical profiles per time and/or convert to zoo object
if(HAVG_CNT3){
  avg = lapply(dat, function(x){x[1,1,,]})
} else{
  # average horizontally resulting in a value per height and time
  avg = lapply(X = dat, FUN = apply, 3:4, mean)
}
# transpose
avg = lapply(X = avg, FUN = t)
# convert to zoo object with time in s
avg = lapply(X = avg, FUN = zoo, order.by = seq(P_CNT3 * DT / 2, by = P_CNT3 * DT, length.out = nrow(avg[[1]])))

# convert into units of deg C
avg$t = avg$t * t_scale - 273.15
# convert from kg/kg to g/kg
avg$q = avg$q * 1000


